using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs.GUI;
using CONTROLS = gov.va.med.vbecs.GUI.controls;
using System.Text.RegularExpressions;
using System.Text;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for DataGridDATC3.
	/// </summary>
	public class DataGridDatC3 : System.Windows.Forms.Panel
	{
		private Hashtable resultLookup;
		private System.Windows.Forms.DataGridTableStyle _dgAntiC3TableStyle;
		private System.Windows.Forms.DataGridTextBoxColumn _dcTextBox;
		private controls.DataGridKeyTrapTextBoxColumn _dcTextKeyTrapCol;
		//
		private gov.va.med.vbecs.GUI.controls.VbecsDataGrid dgAntiC3;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.ComponentModel.IContainer components;
		private DataTable _dtDATC3d;
		private BOL.Division _division;
		private string _validEntries;
		private controls.ComboBoxLookup cmbBox;
		private controls.ComboBoxLookup cmbBoxComment;
		private DataTable _dtReagents;
		private BOL.OrderedTest _orderedTest;
		private string _testingTech;
		private DateTime _testDate;
		private System.Guid _parentFormGuid = System.Guid.Empty;
		private DataTable _dtRemovedLotNumbers;
		private bool _keyPressEventHandled; //CR 2792

		/// <summary>
		/// enableInvalidation
		/// </summary>
		public bool enableInvalidation;
		
		/// <summary>
		/// CellChanged Event
		/// </summary>
		public event CellChangedEventHandler CellChanged;
		
		/// <summary>
		/// The constructor of the control
		/// </summary>
		public DataGridDatC3()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			//I put this try/catch just to make this control appear on the UC_56 main windows in the design view
			try
			{
				this._division = new BOL.Division(Common.LogonUser.LogonUserDivisionCode);
			}
			catch{}

			InitializeGrid();

			_dtRemovedLotNumbers = new DataTable();
			_dtRemovedLotNumbers.Columns.Add(ARTIFICIAL.Lot_Number);
			_dtRemovedLotNumbers.Columns.Add(ARTIFICIAL.Manufacturer);
			_dtRemovedLotNumbers.CaseSensitive = true;
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DataGridDatC3));
			this.dgAntiC3 = new gov.va.med.vbecs.GUI.controls.VbecsDataGrid();
			this.cmbBox = new controls.ComboBoxLookup();
			this.cmbBoxComment = new controls.ComboBoxLookup();
			this.btnClear = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			((System.ComponentModel.ISupportInitialize)(this.dgAntiC3)).BeginInit();
			this.SuspendLayout();
			// 
			// dgAntiC3
			// 
			this.dgAntiC3.AllowSorting = false;
			this.dgAntiC3.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.dgAntiC3.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgAntiC3.CaptionText = "Direct Antiglobulin Test (DAT Comp)";
			this.dgAntiC3.CaptionVisible = false;
			this.dgAntiC3.DataMember = string.Empty;
			this.dgAntiC3.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgAntiC3.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgAntiC3.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgAntiC3.Name = "dgAntiC3";
			this.dgAntiC3.RowHeadersVisible = false;
			this.dgAntiC3.Size = new System.Drawing.Size(344, 76);
			this.dgAntiC3.TabIndex = 63;
			this.dgAntiC3.ToolTipColumn = -1;
			this.dgAntiC3.CurrentCellChanged += new System.EventHandler(this.dgAntiC3_CurrentCellChanged);
			// 
			// btnClear
			// 
			this.btnClear.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.btnClear.Image = ((System.Drawing.Bitmap)(resources.GetObject("btnClear.Image")));
			this.btnClear.Location = new System.Drawing.Point(322, 1);
			this.btnClear.Name = "btnClear";
			this.btnClear.Size = new System.Drawing.Size(20, 20);
			this.btnClear.TabIndex = 64;
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			this.toolTip1.SetToolTip(this.btnClear, Common.StrRes.Tooltips.Common.ClearResults().ResString);
			// 
			// cmbBox
			// 
			this.cmbBox.MaxLength = 15;
			this.cmbBox.Name = "cmbBox";
			this.cmbBox.TabIndex = 0;
			this.cmbBox.Width = 93;
			this.cmbBox.SelectedIndexChanged += new System.EventHandler(this.cmbBox_SelectedIndexChanged);
			this.cmbBox.Validating += new System.ComponentModel.CancelEventHandler(this.cmbBox_Validating);
			// 
			// cmbBoxComment
			// 
			this.cmbBoxComment.MaxLength = 255;
			this.cmbBoxComment.Name = "cmbBoxComment";
			this.cmbBoxComment.TabIndex = 0;
			this.cmbBoxComment.Width = 58;
			this.cmbBoxComment.Validating += new System.ComponentModel.CancelEventHandler(this.cmbBoxComment_Validating);
			// 
			// toolTip1
			// 
			this.toolTip1.ShowAlways = true;
			// 
			// DataGridDatC3
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btnClear,
																		  this.dgAntiC3});
			this.Name = "DataGridDatC3";
			this.Size = new System.Drawing.Size(344, 76);
			((System.ComponentModel.ISupportInitialize)(this.dgAntiC3)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		#region Locking

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		public event EventHandler UserActivity;

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		protected void OnUserActivity()
		{
			if (this.UserActivity != null)
				this.UserActivity(this, System.EventArgs.Empty);
		}

		/// <summary>
		/// Guid of the control's container - needed for locking
		/// </summary>
		public System.Guid ParentFormGuid
		{
			get
			{
				if (this._parentFormGuid == System.Guid.Empty)
				{
					throw new BOL.BusinessObjectException("Locking Requirement missing -- ParentFormGuid not set.");
				}
				return(this._parentFormGuid);
			}
			set
			{
				this._parentFormGuid = value;
			}
		}

		#endregion

		/// <summary>
		/// Set or get the division code
		/// </summary>
		public string DivisionCode
		{
			get
			{
				return this._division.DivisionCode;
			}
			set
			{
				if (value != null)
				{
					this._division = new BOL.Division(value);
				}
			}
		}

		/// <summary>
		/// Get the valid entries description for grid cell
		/// </summary>
		public string ValidEntries
		{
			get
			{
				return this._validEntries;
			}
		}

		/// <summary>
		/// Get the LotNumber from the current row
		/// </summary>
		public string LotNumber
		{
			get
			{
				int row = this.dgAntiC3.CurrentCell.RowNumber;
				if (this._dtDATC3d.Rows[row].IsNull(TABLE.Reagent.LotNumber) == false)
					return this._dtDATC3d.Rows[row][TABLE.Reagent.LotNumber].ToString();
				else
					return string.Empty;
			}
		}

		/// <summary>
		/// Get the expiration date from the current row
		/// </summary>
		public DateTime ExpirationDate
		{
			get
			{
				int row = this.dgAntiC3.CurrentCell.RowNumber;
				if (this._dtDATC3d.Rows[row].IsNull(TABLE.ExceptionExpiredUnitReceived.ExpirationDate) == false)
					return (DateTime)this._dtDATC3d.Rows[row][TABLE.ExceptionExpiredUnitReceived.ExpirationDate];
				else
					return DateTime.MinValue;
			}
		}

		/// <summary>
		/// Get the manufacturer from the current row
		/// </summary>
		public string Manufacturer
		{
			get
			{
				int row = this.dgAntiC3.CurrentCell.RowNumber;
				if (this._dtDATC3d.Rows[row].IsNull(ARTIFICIAL.Manufacturer) == false)
					return this._dtDATC3d.Rows[row][ARTIFICIAL.Manufacturer].ToString();
				else
					return string.Empty;
			}
		}

		/// <summary>
		/// Get the ReagentGuid from the current row
		/// </summary>
		public Guid ReagentGuid
		{
			get
			{
				int row = this.dgAntiC3.CurrentCell.RowNumber;
				if (this._dtDATC3d.Rows[row].IsNull(TABLE.Reagent.ReagentGuid) == false)
					return (Guid)this._dtDATC3d.Rows[row][TABLE.Reagent.ReagentGuid];
				else
					return Guid.Empty;
			}
		}

		/// <summary>
		/// Set the OrderedTest object associated with this test
		/// </summary>
		public BOL.OrderedTest OrderedTest
		{
			set
			{
				this._orderedTest = value;
			}
			get
			{
				return this._orderedTest;
			}
		}

		/// <summary>
		/// Get or set the testing tech
		/// </summary>
		public string TestingTech
		{
			get
			{
				return this._testingTech;
			}
			set
			{
				this._testingTech = value;
			}
		}

		/// <summary>
		/// Get or set the testing date
		/// </summary>
		public DateTime TestDate
		{
			get
			{
				return this._testDate;
			}
			set
			{
				this._testDate = value;
			}
		}

		/// <summary>
		/// Get the name of the qc rack
		/// </summary>
		public string RackName
		{
			get
			{
				if (this._dtDATC3d.Rows[0].IsNull(TABLE.Rack.RackGuid) == false)
				{
					BOL.Rack rack = new BOL.Rack((Guid)this._dtDATC3d.Rows[0][TABLE.Rack.RackGuid]);
					return rack.RackName;
				}
				else
					return string.Empty;
			}
		}

		/// <summary>
		/// Invoke cell changed event
		/// </summary>
		/// <param name="e"></param>
		protected virtual void OnCellChanged(System.EventArgs e)
		{
			if (CellChanged != null)
				CellChanged(this.dgAntiC3, e);

			this.OnUserActivity();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Initialize the datagrid and set the DataTableStyle
		/// </summary>
		private void InitializeGrid()
		{
			this.dgAntiC3.CaptionVisible = true;
			this.dgAntiC3.Enter += new System.EventHandler(dgAntiC3_Enter);
			this.dgAntiC3.Leave += new EventHandler(dgAntiC3_Leave);
			this.dgAntiC3.LostFocus +=new EventHandler(dgAntiC3_LostFocus);
			this.dgAntiC3.SizeChanged+=new EventHandler(dgAntiC3_SizeChanged);
			this.dgAntiC3.NextCell += new controls.NextCellEventHandler(SetNextCell);
			
			InitializeLookup();
			
			AddAntiC3CustomDataTableStyle();
			this._keyPressEventHandled = false; //CR 2792
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Creates a hash table of testing results.
		/// </summary>
		private void InitializeLookup()
		{
			// Fill hashtable with the "Positive" and "Negative" values of each test result
			resultLookup = new Hashtable();

			// Empty results
			resultLookup.Add(string.Empty, "X");
			resultLookup.Add("X", "X");
			
			// Positive results
			resultLookup.Add("H", "P");
			resultLookup.Add("W", "P");
			resultLookup.Add("F", "P");
			resultLookup.Add("M", "P");
			resultLookup.Add("1", "P");
			resultLookup.Add("2", "P");
			resultLookup.Add("3", "P");
			resultLookup.Add("4", "P");
			resultLookup.Add("P", "P");

			// Negative results
			resultLookup.Add("R", "N");
			resultLookup.Add("0", "N");
			resultLookup.Add("N", "N");
		}

		/// <summary>
		/// Creates the DAT complement table that is used as a datasource for the datagrid. This method
		/// also creates one row in this table that allows user to enter test results.
		/// </summary>
		/// <param name="test"></param>
		/// <param name="rackGuid"></param>
		/// <returns></returns>
		public DataTable CreateDatC3Table(BOL.OrderedTest test, Guid rackGuid)
		{
			this._orderedTest = test;

			DataTable dt = new System.Data.DataTable("DATC3d");

			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add(ARTIFICIAL.TestType, typeof(string));
			dt.Columns.Add(TABLE.Reagent.LotNumber, typeof(string));
			dt.Columns.Add(ARTIFICIAL.C3d, typeof(string));
			dt.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dt.Columns.Add(ARTIFICIAL.C3dInterp, typeof(string));
			dt.Columns.Add(ARTIFICIAL.C3dComment, typeof(string));
			dt.Columns.Add(TABLE.Patient.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLE.PatientSpecimen.PatientSpecimenGuid, typeof(Guid));
			dt.Columns.Add(TABLE.OrderedTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLE.Reagent.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLE.ReagentType.ReagentTypeId, typeof(int));
			dt.Columns.Add(ARTIFICIAL.Manufacturer, typeof(string));
			dt.Columns.Add(TABLE.ExceptionExpiredUnitReceived.ExpirationDate, typeof(DateTime));
			dt.Columns.Add(TABLE.OrderableTest.OrderableTestId);
			dt.Columns.Add(ARTIFICIAL.SystemC3dInterp, typeof(string));			//never used?
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.LotNumberSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.C3dSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.C3dInterpSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.C3dGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.C3dInterpGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.C3dRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.C3dInterpRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.ReagentExpiredException, typeof(BOL.ExceptionReport));
			dt.Columns.Add(TABLE.SpecimenTest.CorrectedResultIndicator, typeof(bool));	
			dt.Columns.Add(TABLE.Rack.RackGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.IndicatorMessage);

			DataRow dr = dt.NewRow();
			dr[TABLE.Patient.PatientGuid] = test.Patient.PatientGuid;
			dr[TABLE.PatientSpecimen.PatientSpecimenGuid] = test.Specimen.SpecimenGuid;
			dr[TABLE.OrderedTest.OrderedTestGuid] = test.OrderedTestGuid;
			dr[TABLE.OrderableTest.OrderableTestId] = test.OrderableTestId;
			dr[ARTIFICIAL.OrderedTestRowVersion] = test.RowVersion;
			dr[ARTIFICIAL.Indicator] = string.Empty;

			if (test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				dr[TABLE.Reagent.LotNumber] = DBNull.Value;
				dr[ARTIFICIAL.C3d] = DBNull.Value;
				dr[ARTIFICIAL.CC] = DBNull.Value;
				dr[ARTIFICIAL.LotNumberSave] = false;
				dr[ARTIFICIAL.C3dSave] = false;
				dr[ARTIFICIAL.CCSave] = false;
				dr[ARTIFICIAL.TestType] = "Patient";
			}
			else
			{
				dr[ARTIFICIAL.TestType] = "Anti-Comp";
				if (this._division.ServiceTypeIndicator == true)
				{
					dr[TABLE.Reagent.LotNumber] = string.Empty;
					dr[ARTIFICIAL.C3d] = string.Empty;
					dr[ARTIFICIAL.CC] = string.Empty;
					dr[ARTIFICIAL.LotNumberSave] = true;
					dr[ARTIFICIAL.C3dSave] = true;
					dr[ARTIFICIAL.CCSave] = true;
				}
				else
				{
					dr[TABLE.Reagent.LotNumber] = DBNull.Value;
					dr[ARTIFICIAL.C3d] = DBNull.Value;
					dr[ARTIFICIAL.CC] = DBNull.Value;
					dr[ARTIFICIAL.LotNumberSave] = false;
					dr[ARTIFICIAL.C3dSave] = false;
					dr[ARTIFICIAL.CCSave] = false;
				}
			}

			dr[ARTIFICIAL.C3dInterp] = string.Empty;
			dr[ARTIFICIAL.C3dComment] = string.Empty;
			dr[ARTIFICIAL.C3dInterpSave] = true;
			dr[ARTIFICIAL.PartiallyCompleted] = false;
			dr[TABLE.ReagentType.ReagentTypeId] = (int)Common.DATTestControls.CompDAT;  //Anti-C3d
			dr[ARTIFICIAL.IndicatorMessage] = string.Empty;

			if (rackGuid != Guid.Empty)
				dr[TABLE.Rack.RackGuid] = rackGuid;

			if (test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
				dr[TABLE.SpecimenTest.CorrectedResultIndicator] = true;
			else
				dr[TABLE.SpecimenTest.CorrectedResultIndicator] = false;

			dt.Rows.Add(dr);

			this.dgAntiC3.ToolTipColumn = dt.Columns.Count - 1;

			return dt;
		}

		/// <summary>
		/// Adds or removes two rows used to QC C3d reagent
		/// </summary>
		/// <param name="addRows"></param>
		private void AddRemoveQCRowsToDataGrid(bool addRows)
		{
			if (addRows == true)
			{
				DataRow drNeg = this._dtDATC3d.NewRow();
				drNeg[TABLE.Patient.PatientGuid] = this._dtDATC3d.Rows[0][TABLE.Patient.PatientGuid];
				drNeg[TABLE.PatientSpecimen.PatientSpecimenGuid] = this._dtDATC3d.Rows[0][TABLE.PatientSpecimen.PatientSpecimenGuid];
				drNeg[TABLE.OrderedTest.OrderedTestGuid] = this._dtDATC3d.Rows[0][TABLE.OrderedTest.OrderedTestGuid];
				drNeg[TABLE.OrderableTest.OrderableTestId] = this._dtDATC3d.Rows[0][TABLE.OrderableTest.OrderableTestId];
				drNeg[ARTIFICIAL.Indicator] = string.Empty;
				drNeg[ARTIFICIAL.TestType] = "NEG";
				drNeg[TABLE.Reagent.LotNumber] = string.Empty;
				drNeg[ARTIFICIAL.C3d] = string.Empty;
				drNeg[ARTIFICIAL.CC] = string.Empty;
				drNeg[ARTIFICIAL.C3dInterp] = string.Empty;
				drNeg[ARTIFICIAL.C3dComment] = string.Empty;
				drNeg[ARTIFICIAL.LotNumberSave] = true;
				drNeg[ARTIFICIAL.C3dSave] = true;
				drNeg[ARTIFICIAL.CCSave] = true;
				drNeg[ARTIFICIAL.C3dInterpSave] = true;
				drNeg[ARTIFICIAL.PartiallyCompleted] = false;
				drNeg[TABLE.ReagentType.ReagentTypeId] = (int)Common.DATTestControls.CompDATNegControl;  //Screening Cell 1
				drNeg[ARTIFICIAL.OrderedTestRowVersion] = this._dtDATC3d.Rows[0][ARTIFICIAL.OrderedTestRowVersion];
				drNeg[TABLE.Rack.RackGuid] = this._dtDATC3d.Rows[0][TABLE.Rack.RackGuid];
				drNeg[ARTIFICIAL.IndicatorMessage] = string.Empty;

				DataRow drPos = this._dtDATC3d.NewRow();
				drPos[TABLE.Patient.PatientGuid] = this._dtDATC3d.Rows[0][TABLE.Patient.PatientGuid];
				drPos[TABLE.PatientSpecimen.PatientSpecimenGuid] = this._dtDATC3d.Rows[0][TABLE.PatientSpecimen.PatientSpecimenGuid];
				drPos[TABLE.OrderedTest.OrderedTestGuid] = this._dtDATC3d.Rows[0][TABLE.OrderedTest.OrderedTestGuid];
				drPos[TABLE.OrderableTest.OrderableTestId] = this._dtDATC3d.Rows[0][TABLE.OrderableTest.OrderableTestId];
				drPos[ARTIFICIAL.Indicator] = string.Empty;
				drPos[ARTIFICIAL.TestType] = "POS";
				drPos[TABLE.Reagent.LotNumber] = string.Empty;
				drPos[ARTIFICIAL.C3d] = string.Empty;
				drPos[ARTIFICIAL.CC] = string.Empty;
				drPos[ARTIFICIAL.C3dInterp] = string.Empty;
				drPos[ARTIFICIAL.C3dComment] = string.Empty;
				drPos[ARTIFICIAL.LotNumberSave] = true;
				drPos[ARTIFICIAL.C3dSave] = true;
				drPos[ARTIFICIAL.CCSave] = true;
				drPos[ARTIFICIAL.C3dInterpSave] = true;
				drPos[ARTIFICIAL.PartiallyCompleted] = false;
				drPos[TABLE.ReagentType.ReagentTypeId] = (int)Common.DATTestControls.CompDATPosControl;  //Check Cells
				drPos[ARTIFICIAL.OrderedTestRowVersion] = this._dtDATC3d.Rows[0][ARTIFICIAL.OrderedTestRowVersion];
				drPos[TABLE.Rack.RackGuid] = this._dtDATC3d.Rows[0][TABLE.Rack.RackGuid];
				drPos[ARTIFICIAL.IndicatorMessage] = string.Empty;

				object[] objPatient = this._dtDATC3d.Rows[0].ItemArray;
				DataRow drPatient = this._dtDATC3d.NewRow();
				drPatient.ItemArray = objPatient;

				this._dtDATC3d.Rows.Add(drPos);
				this._dtDATC3d.Rows.Add(drNeg);
				this._dtDATC3d.Rows.Add(drPatient);
				this._dtDATC3d.Rows.RemoveAt(0);

				this.dgAntiC3.SetCurrentCell(0,0);
			}
			else
			{
				if (this._dtDATC3d.Rows.Count > 1)
				{
					this._dtDATC3d.Rows.RemoveAt(0);
					this._dtDATC3d.Rows.RemoveAt(0);

					this.dgAntiC3.SetCurrentCell(0,0);
				}
			}
		}

		/// <summary>
		/// Sets the data source for a grid. Transfers DataTable to a DataView and passes it as
		/// a source for a grid.
		/// </summary>
		/// <param name="dt"></param>
		public void SetDataSource(DataTable dt)
		{
			if (dt.Rows.Count == 0)
			{
				this.dgAntiC3.ColumnHeadersVisible = false;
				this.dgAntiC3.DataSource = dt.DefaultView;
				this.btnClear.Enabled = false;
				enableInvalidation = false;
			}
			else
			{
				this.btnClear.Enabled = true;
				enableInvalidation = true;
				this.dgAntiC3.ColumnHeadersVisible = true;
				this.dgAntiC3.DataSource = dt.DefaultView;
				((DataView)dgAntiC3.DataSource).AllowNew = false;
				((DataView)dgAntiC3.DataSource).AllowDelete = false;
				this.cmbBoxComment.SelectedIndex = -1;

				this._dtDATC3d = dt;
				for (int i=0 ; i<dt.Rows.Count ; i++)
				{
					UpdateIndicator(i);
				}
			}
		}

		/// <summary>
		/// Enables or disables the grid
		/// </summary>
		/// <param name="status"></param>
		public void SetGridStatus(bool status)
		{
			this.dgAntiC3.Enabled = status;
		}

		/// <summary>
		/// Check if data on the grid is ready to be saved
		/// </summary>
		/// <returns></returns>
		public bool IsReadyToSave()
		{
			DataTable dt = ((DataView)this.dgAntiC3.DataSource).Table;

			if (dt.Rows.Count == 0)
				return true;

			if (this._division.ServiceTypeIndicator == true ||
				this._orderedTest.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				for (int i=0 ; i<this._dtDATC3d.Rows.Count ; i++)
				{
					if (dt.Rows[i].IsNull(TABLE.Reagent.ReagentGuid) == true ||
						dt.Rows[i][ARTIFICIAL.Indicator].ToString() == "E")
						return false;
				}
			}
			else
			{
				for (int i=0 ; i<this._dtDATC3d.Rows.Count ; i++)
				{
					if (dt.Rows[i][ARTIFICIAL.Indicator].ToString() == string.Empty)
						return false;
				}
			}

			return true;
		}

		/// <summary>
		/// Adds the custom data table style to the data grid.
		/// </summary>
		private void AddAntiC3CustomDataTableStyle()
		{
			_dgAntiC3TableStyle = new DataGridTableStyle();
			_dgAntiC3TableStyle.PreferredRowHeight = 22;
			_dgAntiC3TableStyle.AllowSorting = false;
			_dgAntiC3TableStyle.DataGrid = this.dgAntiC3;

			_dgAntiC3TableStyle.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)), true);
			_dgAntiC3TableStyle.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			_dgAntiC3TableStyle.MappingName = "DATC3d";
			_dgAntiC3TableStyle.RowHeadersVisible = false;
			// 
			// Indicator
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Indicator;
			_dcTextKeyTrapCol.ReadOnly = true;
			_dcTextKeyTrapCol.Width = 20;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			// 
			// PatientControl
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = string.Empty;
			_dcTextBox.MappingName = ARTIFICIAL.TestType;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 60;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// Lot Number
			// 
			if (this._division != null)
			{
				if (this._division.ServiceTypeIndicator == true)
				{
					_dcTextBox = new DataGridTextBoxColumn();
					_dcTextBox.HeaderText = "Lot Number";
					_dcTextBox.MappingName = TABLE.Reagent.LotNumber;
					_dcTextBox.Width = 95;
					_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
					_dcTextBox.TextBox.Controls.Add(cmbBox);
					cmbBox.BringToFront();
					cmbBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
				}
				else
				{
					_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
					_dcTextKeyTrapCol.HeaderText = "Lot Number";
					_dcTextKeyTrapCol.MappingName = TABLE.Reagent.LotNumber;
					_dcTextKeyTrapCol.Width = 95;
					_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
				}
			}
			// 
			// AntiC3d
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Anti-Comp";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.C3d;
			_dcTextKeyTrapCol.Width = 60;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// CC
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.Width = 25;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// AntiC3dInterp
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Interp.";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.C3dInterp;
			_dcTextKeyTrapCol.Width = 35;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// AntiC3dComment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = ARTIFICIAL.Comment;
			_dcTextBox.MappingName = ARTIFICIAL.C3dComment;
			_dcTextBox.Width = 60;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			_dcTextBox.TextBox.Controls.Add(cmbBoxComment);
			cmbBoxComment.BringToFront();
			cmbBoxComment.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			// 
			// dcPatientGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Patient.PatientGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPatientSpecimenGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.PatientSpecimen.PatientSpecimenGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderedTestGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedTest.OrderedTestGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcReagentGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Reagent.ReagentGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcReagentTypeID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ReagentType.ReagentTypeId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcManufacturer
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.Manufacturer;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcExpirationDate
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ExceptionExpiredUnitReceived.ExpirationDate;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderableTestID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderableTest.OrderableTestId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcSystemAGHInterp
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.SystemIgGInterp;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPartiallyCompleted
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.PartiallyCompleted;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcLotNumberSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.LotNumberSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcC3dSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C3dSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcC3dInterpSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C3dInterpSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcC3dGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C3dGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcC3dInterpGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C3dInterpGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcC3dRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C3dRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcC3dInterpRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C3dInterpRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRowVersionOrderedTest
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.OrderedTestRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcReagentExpiredException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ReagentExpiredException;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCorrectedResultIndicator
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.SpecimenTest.CorrectedResultIndicator;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRackGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Rack.RackGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcIndicatorMessage
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.IndicatorMessage;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntiC3TableStyle.GridColumnStyles.Add(_dcTextBox);

			dgAntiC3.TableStyles.Add(_dgAntiC3TableStyle);				
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// This code traps each key stroke to allow movement to the next cell for the columns that only 
		/// require a single valid key stroke.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key Press Event Args</param>
		private void _dcTextKeyTrapCol_TextBoxKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int row = this.dgAntiC3.CurrentCell.RowNumber;
				int column = this.dgAntiC3.CurrentCell.ColumnNumber;
				string cellText = string.Empty;
				string cellTextFuture = string.Empty;
				string KeyChar = string.Empty;
				string regPattern = string.Empty;
			
				TextBox c = (TextBox) sender;

				cellText = c.Text;
			
				// Let backspace and enter keys bypass
				if (!char.IsLetterOrDigit(e.KeyChar))
				{
					if (column == 6 && e.KeyChar == System.Convert.ToChar(Keys.Enter))
					{
						SetNextCell();
					}

					e.Handled = !char.IsControl(e.KeyChar);
					return;
				}

				if (column == 6)
					return;
			
				// Turn single character to upper
				KeyChar = e.KeyChar.ToString().ToUpper()[0].ToString();

				// Obtain what the string will look like after key is pressed
				if (cellText.Length > 0)
				{
					cellTextFuture = cellText.Substring(0, c.SelectionStart) + KeyChar + cellText.Substring(c.SelectionStart + c.SelectionLength, cellText.Length - (c.SelectionLength + c.SelectionStart));
				}
				else
				{
					cellTextFuture = KeyChar;
				}

				// Test what type of column it is and then apply the regular expression

				if (column == 5)  // interp
				{
					regPattern = @"(\A[PN]\z)";
				}
				else if (column == 3)			// C3d
				{
					regPattern = @"(\A[HWFM01234]\z)";
				}
				else if (column == 4)			// CC
				{
					regPattern = @"(\A[HWFM01234X]\z)";
				}

				if (Regex.IsMatch(cellTextFuture, regPattern))
				{
					//changing values in the datable causes TextChanged event to be fired
					//setting a flag to prevent it from happening
					this._keyPressEventHandled = true;

					c.Text = cellTextFuture;
					c.SelectionStart = c.SelectionLength + 1;
					DataTable dt = ((DataView)this.dgAntiC3.DataSource).Table;
					dt.Rows[row][column] = c.Text;
					SetNextCell();
					UpdateIndicator(row);
					this._keyPressEventHandled = false;
				}
				else
				{
					MessageBox.Show(Common.StrRes.ValidMsg.Common.DataGridInvalidKeyLngMsg().ResString, Common.StrRes.ValidMsg.Common.InvalidKeyPressed().ResString);
				}
			
				e.Handled = true;
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// This method handles entering invalid entries into the grid (CR 2792)
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void _dcTextKeyTrapCol_TextChanged(object sender, EventArgs e)
		{
			//if the grid just received focus do not continue executing this event
			if (this.dgAntiC3.GridEntered == true)
			{
				this.dgAntiC3.GridEntered = false;
				return;
			}

			if (this._keyPressEventHandled || this.dgAntiC3.EnterKeyPressed == true)
			{
				return;
			}
			else
			{
				int row = this.dgAntiC3.CurrentCell.RowNumber;
				int column = this.dgAntiC3.CurrentCell.ColumnNumber;
				DataTable dt = ((DataView)this.dgAntiC3.DataSource).Table;
			
				//forcing the validation of the grid
				if (sender is System.Windows.Forms.DataGridTextBox)
				{
					//if the grid cell has anything in it run the regex match
					if (((DataGridTextBox)sender).Text != "" && ((DataGridTextBox)sender).Text != "(null)")
					{
						string regPattern = "";

						// Test what type of column it is and then apply the regular expression
						if (column == 5)  // interp
						{
							regPattern = @"(\A[PN]\z)";
						}
						else if (column == 3)			// C3d
						{
							regPattern = @"(\A[HWFM01234]\z)";
						}
						else if (column == 4)			// CC
						{
							regPattern = @"(\A[HWFM01234X]\z)";
						}

						if (Regex.IsMatch(((DataGridTextBox)sender).Text, regPattern))
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							dt.Rows[row][column] = ((DataGridTextBox)sender).Text;
							for (int i=0 ; i<this._dtDATC3d.Rows.Count ; i++)
							{
								UpdateIndicator(i);
							}
							this.dgAntiC3.Refresh();
							OnCellChanged(EventArgs.Empty);
							this._keyPressEventHandled = false;
						}
						else
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							((DataGridTextBox)sender).Text = dt.Rows[row][column].ToString();
							this._keyPressEventHandled = false;
							//BR_2.28
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
						}
					}
						//user hit Del key and the grid cell is blank - refresh grid, do not run regex match
					else
					{
						//changing values in the datable causes TextChanged event to be fired
						//setting a flag to prevent it from happening
						this._keyPressEventHandled = true;
						dt.Rows[row][column] = "";
						for (int i=0 ; i<this._dtDATC3d.Rows.Count ; i++)
						{
							UpdateIndicator(i);
						}
						this.dgAntiC3.Refresh();
						OnCellChanged(EventArgs.Empty);
						this._keyPressEventHandled = false;
					}
				}
			}
		}

		/// <summary>
		/// Controls the movement of the cursor on the datagrid.
		/// </summary>
		private void SetNextCell()
		{
			int row = this.dgAntiC3.CurrentCell.RowNumber;
			int col = this.dgAntiC3.CurrentCell.ColumnNumber;

			if (row == this._dtDATC3d.Rows.Count - 1)
			{
				if (col < 6 && col > 1)
				{
					this.dgAntiC3.SetCurrentCell(0, col+1);
				}
				else if (col == 6)
				{
					this.dgAntiC3.SetCurrentCell(0, 0);
				}
			}
			else
			{
				this.dgAntiC3.SetCurrentCell(row + 1, col);
			}
		}

		/// <summary>
		/// Updates the datagrid indicator to indicate the status of test results
		/// </summary>
		private void UpdateIndicator(int row)
		{
			DataRow drUpdate = this._dtDATC3d.Rows[row];

			if (this._division.ServiceTypeIndicator == true ||
				this._orderedTest.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				string C3dResult = resultLookup[drUpdate[ARTIFICIAL.C3d].ToString()].ToString();
				string CCResult = resultLookup[drUpdate[ARTIFICIAL.CC].ToString()].ToString();
				string Interp = drUpdate[ARTIFICIAL.C3dInterp].ToString();

				if (C3dResult == string.Empty || CCResult == string.Empty)
				{
					drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
					drUpdate[ARTIFICIAL.Indicator] = string.Empty;
				}
				else
				{
					if (Interp != string.Empty)
					{
						if (CCResult == "N" || drUpdate[ARTIFICIAL.CC].ToString().Trim() == string.Empty ||
							(C3dResult == "N" && drUpdate[ARTIFICIAL.CC].ToString().Trim() == "X"))
						{
							if (drUpdate[ARTIFICIAL.Indicator].ToString() != "E")
							{
								drUpdate[ARTIFICIAL.Indicator] = "E";
								drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC054.InvalidEntry().ResString;
							}
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
						else
						{
							if (drUpdate[ARTIFICIAL.TestType].ToString() == "Patient")
							{
								if ((C3dResult == "P" && Interp == "P") ||
									(C3dResult == "N" && Interp == "N"))
								{
									drUpdate[ARTIFICIAL.Indicator] = "V";
									drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
									drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
								}
								else
								{
									if (drUpdate[ARTIFICIAL.Indicator].ToString() != "E")
									{
										drUpdate[ARTIFICIAL.Indicator] = "E";
										drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC054.InvalidEntry().ResString;
									}
									drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
								}
							}
							else if (drUpdate[ARTIFICIAL.TestType].ToString() == "POS")
							{
								if (C3dResult == "P" && Interp == "P")
								{
									drUpdate[ARTIFICIAL.Indicator] = "V";
									drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
									drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
								}
								else
								{
									if (drUpdate[ARTIFICIAL.Indicator].ToString() != "E")
									{
										drUpdate[ARTIFICIAL.Indicator] = "E";
										drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC054.InvalidEntry().ResString;
									}
									drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
								}
							}
							else if (drUpdate[ARTIFICIAL.TestType].ToString() == "NEG")
							{
								if (C3dResult == "N" && Interp == "N")
								{
									drUpdate[ARTIFICIAL.Indicator] = "V";
									drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
									drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
								}
								else
								{
									if (drUpdate[ARTIFICIAL.Indicator].ToString() != "E")
									{
										drUpdate[ARTIFICIAL.Indicator] = "E";
										drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC054.InvalidEntry().ResString;
									}
									drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
								}
							}
						}
					}
					else
					{
						drUpdate[ARTIFICIAL.Indicator] = string.Empty;
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
					}
				}
			}
			else //Transfusion-Only
			{
				if (drUpdate[ARTIFICIAL.C3dInterp].ToString().Trim() != string.Empty)
				{
					drUpdate[ARTIFICIAL.Indicator] = "V";
					drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
					drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
				}
				else
				{
					drUpdate[ARTIFICIAL.Indicator] = string.Empty;
					drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
					drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
				}
			}
		}

		/// <summary>
		/// Displays the valid values for each column in the legend.
		/// </summary>
		/// <param name="column"></param>
		public void SetValidEntries(int column)
		{		
			// Test what type of column it is and then apply the regular expression
			
			if (column == 2)	//Lot Number
			{
				_validEntries = "Lot Number";
			}
			else if (column == 3)		// C3d
			{
				_validEntries = "0 = No Agglutination, 1 = 1+, 2 = 2+, 3 = 3+, 4 = 4+, H = Hemolysis, W = Weak, F = Mixed Field, M = Microscopic";
			}
			else if (column == 4)		// CC
			{
				_validEntries = "0 = No Agglutination, 1 = 1+, 2 = 2+, 3 = 3+, 4 = 4+, H = Hemolysis, W = Weak, F = Mixed Field, M = Microscopic, X = Not Tested";
			}
			else if (column == 5)  // IgG interp
			{
				_validEntries = "P = Positive, N = Negative";
			}
			else if (column == 6)		// IgG Comment
			{
				_validEntries = "Any Text";
			}
			else
			{
				_validEntries = "Read-Only";
			}
		}

		/// <summary>
		/// Clears the test results from the grid. Restores datagrid to the initial status.
		/// </summary>
		private void ClearTestResults(bool clearAll)
		{
			if (this._dtDATC3d.Rows.Count > 0)
			{
				if (this._division.ServiceTypeIndicator == true ||
					this._orderedTest.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					foreach(DataRow drDAT in this._dtDATC3d.Rows)
					{
						if ((bool)drDAT[ARTIFICIAL.LotNumberSave] == true ||
							clearAll == true)
						{
							drDAT[TABLE.Reagent.LotNumber] = string.Empty;
							drDAT[TABLE.ExceptionExpiredUnitReceived.ExpirationDate] = DBNull.Value;
							drDAT[ARTIFICIAL.Manufacturer] = string.Empty;
							drDAT[TABLE.Reagent.ReagentGuid] = DBNull.Value;
							if (clearAll == true)
								drDAT[ARTIFICIAL.LotNumberSave] = true;
						}

						if ((bool)drDAT[ARTIFICIAL.C3dSave] == true ||
							clearAll == true)
						{
							drDAT[ARTIFICIAL.C3d] = string.Empty;
							if (clearAll == true)
							{
								drDAT[ARTIFICIAL.C3dGuid] = DBNull.Value;
								drDAT[ARTIFICIAL.C3dRowVersion] = DBNull.Value;
								drDAT[ARTIFICIAL.C3dSave] = true;
							}
						}

						if ((bool)drDAT[ARTIFICIAL.CCSave] == true ||
							clearAll == true)
						{
							drDAT[ARTIFICIAL.CC] = string.Empty;
							if (clearAll == true)
							{
								drDAT[ARTIFICIAL.CCGuid] = DBNull.Value;
								drDAT[ARTIFICIAL.CCRowVersion] = DBNull.Value;
								drDAT[ARTIFICIAL.CCSave] = true;
							}
						}

						if ((bool)drDAT[ARTIFICIAL.C3dInterpSave] == true ||
							clearAll == true)
						{
							drDAT[ARTIFICIAL.C3dInterp] = string.Empty;
							if (clearAll == true)
							{
								drDAT[ARTIFICIAL.C3dInterpGuid] = DBNull.Value;
								drDAT[ARTIFICIAL.C3dInterpRowVersion] = DBNull.Value;
								drDAT[ARTIFICIAL.C3dInterpSave] = true;
							}
						}

						drDAT[ARTIFICIAL.C3dComment] = string.Empty;
						drDAT[ARTIFICIAL.ReagentExpiredException] = DBNull.Value;
					}
				}
				else //Transfusion-Only
				{
					foreach(DataRow drDAT in this._dtDATC3d.Rows)
					{
						if ((bool)drDAT[ARTIFICIAL.C3dInterpSave] == true ||
							clearAll == true)
						{
							drDAT[ARTIFICIAL.C3dInterp] = string.Empty;
							if (clearAll == true)
							{
								drDAT[ARTIFICIAL.C3dInterpGuid] = DBNull.Value;
								drDAT[ARTIFICIAL.C3dInterpRowVersion] = DBNull.Value;
								drDAT[ARTIFICIAL.C3dInterpSave] = true;
							}
						}

						drDAT[ARTIFICIAL.C3dComment] = string.Empty;
					}
				}

				for (int i=0; i<this._dtDATC3d.Rows.Count; i++)
				{
					UpdateIndicator(i);
				}
				this.dgAntiC3.SetCurrentCell(0, 1);
			}
		}

		/// <summary>
		/// Handles the CellChanged event for datagrid. Controls the movement of the cursor
		/// on the gird and updates the indicator flag after each cell is edited.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dgAntiC3_CurrentCellChanged(object sender, System.EventArgs e)
		{
			try
			{
				int col = this.dgAntiC3.CurrentCell.ColumnNumber;
				int row = this.dgAntiC3.CurrentCell.RowNumber;
				bool fullGrid = true;

				foreach (DataRow drDAT in this._dtDATC3d.Rows)
				{
					if ((bool)drDAT[ARTIFICIAL.LotNumberSave] == true ||
						(bool)drDAT[ARTIFICIAL.C3dSave] == true ||
						(bool)drDAT[ARTIFICIAL.CCSave] == true ||
						(bool)drDAT[ARTIFICIAL.C3dInterpSave] == true)
					{
						fullGrid = false;
					}
				}

				if (fullGrid == true)
				{
					this.dgAntiC3.Enabled = false;
					return;
				}

				if (this._division.ServiceTypeIndicator == true ||
					this._orderedTest.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					if (this._dtDATC3d.Rows[row].IsNull(TABLE.Reagent.ReagentGuid) && col != 2)
					{
						this.dgAntiC3.SetCurrentCell(row, 2);
						return;
					}

					if (col == 0 || col == 1)
					{
						this.dgAntiC3.SetCurrentCell(row, 2);
						return;
					}

					switch(this.dgAntiC3.CurrentCell.ColumnNumber)
					{
						case 2:
							if ((bool)this._dtDATC3d.Rows[row][ARTIFICIAL.LotNumberSave] == false)
							{
								SetNextCell();
								return;
							}
							break;
						case 3:
							if ((bool)this._dtDATC3d.Rows[row][ARTIFICIAL.C3dSave] == false)
							{
								SetNextCell();
								return;
							}
							break;
						case 4:
							if ((bool)this._dtDATC3d.Rows[row][ARTIFICIAL.CCSave] == false)
							{
								SetNextCell();
								return;
							}
							break;
						case 5:
							if ((bool)this._dtDATC3d.Rows[row][ARTIFICIAL.C3dInterpSave] == false)
							{
								SetNextCell();
								return;
							}
							break;
					}
				}
				else //Transfusion-Only
				{
					if (col < 5)
					{
						this.dgAntiC3.SetCurrentCell(row, 5);
					}
				}

				if (col > 6)
					this.dgAntiC3.SetCurrentCell(row, 6);
				else if (col == 2)
				{
					if (this._dtDATC3d.Rows[row][ARTIFICIAL.TestType].ToString() == "POS" ||
						this._dtDATC3d.Rows[row][ARTIFICIAL.TestType].ToString() == "NEG")
					{
						DataTable dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.ReverseABO);
						this._dtReagents = dtTmpReagents.Copy();
						this._dtReagents.CaseSensitive = true;

						dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.A2Cell);
						foreach(DataRow dr in dtTmpReagents.Rows)
						{
							this._dtReagents.Rows.Add(dr.ItemArray);
						}

						dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.ScreeningCells);
						foreach(DataRow dr in dtTmpReagents.Rows)
						{
							this._dtReagents.Rows.Add(dr.ItemArray);
						}

						dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.ComplementCheckCell);
						foreach(DataRow dr in dtTmpReagents.Rows)
						{
							this._dtReagents.Rows.Add(dr.ItemArray);
						}

						dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.CellPanel);
						foreach(DataRow dr in dtTmpReagents.Rows)
						{
							this._dtReagents.Rows.Add(dr.ItemArray);
						}
				
						dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.OtherSet);
						foreach(DataRow dr in dtTmpReagents.Rows)
						{
							this._dtReagents.Rows.Add(dr.ItemArray);
						}
					}
					else
					{
						_dtReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)this._dtDATC3d.Rows[row][TABLE.ReagentType.ReagentTypeId]);
						this._dtReagents.CaseSensitive = true;
					}

					DataView dv = new DataView(_dtReagents);
					dv.Sort = TABLE.Reagent.LotExpirationDate + " DESC";
					cmbBox.Items.Clear();
					foreach(DataRowView drReagent in dv)
					{
						if (this._dtRemovedLotNumbers.Select("Lot_Number = '" + drReagent.Row[TABLE.Reagent.LotNumber].ToString().Replace("'", "''") + "' AND Manufacturer = '" + drReagent.Row[TABLE.Reagent.ReagentManufacturerName].ToString().Replace("'", "''") + "'").Length == 0)
							cmbBox.Items.Add(drReagent[TABLE.Reagent.LotNumber].ToString());
					}

					cmbBox.Text = this._dtDATC3d.Rows[row][TABLE.Reagent.LotNumber].ToString();

					cmbBox.Show();
					cmbBox.Focus();
				}
				else if (col == 6)
				{
					if ((bool)this._dtDATC3d.Rows[row][ARTIFICIAL.C3dInterpSave] == false ||
						this._dtDATC3d.Rows[row][ARTIFICIAL.C3dInterp].ToString() == string.Empty)
					{
						SetNextCell();
					}
					else
					{
						if (this.cmbBoxComment.Items.Count == 0)
						{
							DataTable dtCannedComments = BOL.CannedComment.GetCannedComments(this.DivisionCode, "PT");
							foreach (DataRow drComment in dtCannedComments.Rows)
							{
								this.cmbBoxComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText]);
							}
							this.cmbBoxComment.LookupEnabled = false;
						}
						this.cmbBoxComment.Text = this._dtDATC3d.Rows[row][ARTIFICIAL.C3dComment].ToString();
						this.cmbBoxComment.Show();
						this.cmbBoxComment.Focus();
					}
				}

				for (int i=0 ; i<this._dtDATC3d.Rows.Count ; i++)
				{
					UpdateIndicator(i);
				}

				SetValidEntries(this.dgAntiC3.CurrentCell.ColumnNumber);
				OnCellChanged(EventArgs.Empty);
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Handles the KeyDown event for combobox.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBox_KeyDown(object sender, KeyEventArgs e)
		{
			try
			{
				if (e.KeyCode == Keys.Enter)
				{
					if(this.dgAntiC3.CurrentCell.RowNumber < ((DataTable)this.dgAntiC3.DataSource).Rows.Count - 1)
					{
						this.dgAntiC3.SetCurrentCell(this.dgAntiC3.CurrentCell.RowNumber + 1, this.dgAntiC3.CurrentCell.ColumnNumber);
						cmbBox.Show();
						cmbBox.Focus();
					}
					else
					{
						this.dgAntiC3.SetCurrentCell(0, this.dgAntiC3.CurrentCell.ColumnNumber+1);
						cmbBox.Hide();
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Handles the IndexChanged event for combobox. Finds the reagent based on the lot number
		/// chosen and populates grid with the appropriate data.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBox_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (cmbBox.SelectedIndex != -1)
				{
					int row = this.dgAntiC3.CurrentCell.RowNumber;

                    // CR2814: Add an escape character so queries with single quotes don't crash.
                    DataRow drReagent = this._dtReagents.Select("LotNumber='" + cmbBox.SelectedItem.ToString().Replace("'", "''") + "'")[0];

					if (this._dtDATC3d.Rows[row][TABLE.Reagent.LotNumber].ToString().Trim() != drReagent[TABLE.Reagent.LotNumber].ToString().Trim())
					{
						if (this.CheckForExpiredAntisera(drReagent) == true &&
							this.CheckForSatisfactoryReagent(drReagent) == true)
						{
							this._dtDATC3d.Rows[row][TABLE.Reagent.LotNumber] = drReagent[TABLE.Reagent.LotNumber];
							this._dtDATC3d.Rows[row][TABLE.ExceptionExpiredUnitReceived.ExpirationDate] = drReagent[TABLE.Reagent.LotExpirationDate];
							this._dtDATC3d.Rows[row][ARTIFICIAL.Manufacturer] = drReagent[TABLE.Reagent.ReagentManufacturerName];
							this._dtDATC3d.Rows[row][TABLE.Reagent.ReagentGuid] = drReagent[TABLE.Reagent.ReagentGuid];
							this._dtDATC3d.Rows[row][TABLE.ReagentType.ReagentTypeId] = drReagent[TABLE.ReagentType.ReagentTypeId];

							if (this._dtDATC3d.Rows[row][ARTIFICIAL.TestType].ToString() == "Anti-Comp")
							{
								this._dtDATC3d.Rows[row][ARTIFICIAL.TestType] = "Patient";
							}

							if (this._dtDATC3d.Rows[row][ARTIFICIAL.TestType].ToString() == "Patient")
							{
								DataTable dtReagentTestResults = BOL.RackTest.GetReagentTestResult(this.DivisionCode, (Guid)this._dtDATC3d.Rows[row][TABLE.Reagent.ReagentGuid], this.TestDate);
								if (dtReagentTestResults.Rows.Count == 0 && this._dtDATC3d.Rows.Count == 1)
								{
									this.AddRemoveQCRowsToDataGrid(true);
								}
								else if (dtReagentTestResults.Rows.Count > 0 && this._dtDATC3d.Rows.Count == 3)
								{
									this.AddRemoveQCRowsToDataGrid(false);
								}
							}
							this.dgAntiC3.SetCurrentCell(row, 1);
						}
						else
						{
							cmbBox.Text = string.Empty;
							this.dgAntiC3.SetCurrentCell(row, 1);
						}
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Checks if the user entered the valid lot number.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBox_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			try
			{
				if (this.cmbBox.SelectedIndex == -1 &&
					this.cmbBox.Text.Trim() != string.Empty)
					e.Cancel = true;
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Clears the datagrid.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			ClearGrid();
			this.OnUserActivity();
		}

		/// <summary>
		/// Clears the grid. This method is public because it is being invoked by context menu from main form of the UC_56
		/// </summary>
		public void ClearGrid()
		{
			if (this.IsGridEmpty() == true)
				return;

			if (this.IsGridPartiallyCompleted() == true)
			{
				DlgOverrideComment dlg = new DlgOverrideComment("Inactivate test results", "Do you want to inactivate test results for this task?", "PT");

                VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                dlg.ShowDialogFromLockedParent(parentForm, false);
                if (dlg.DialogResult == DialogResult.OK)
				{
					BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Previously_recorded_results_inactivated, dlg.Comment, Common.LogonUser.LogonUserName);
					exRep.GenerateExceptionPatientTestInactivated(this._orderedTest, this._testingTech);
					
					this._orderedTest.InactivateTestResults(exRep, Common.UpdateFunction.DataGridDatC3ClearGrid);
					this.ClearTestResults(true);
					this.AddRemoveQCRowsToDataGrid(false);
				}
				else
					return;
			}
			else
			{
				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC056.ClearTestResults()) == DialogResult.Yes)
				{
					this.ClearTestResults(false);
					this.AddRemoveQCRowsToDataGrid(false);
				}
				else
					return;
			}
			this._dtDATC3d.Rows[0][ARTIFICIAL.OrderedTestRowVersion] = this._orderedTest.RowVersion;
		}

		/// <summary>
		/// Check if grid is empty (contains no test results)
		/// </summary>
		/// <returns></returns>
		public bool IsGridEmpty()
		{
			if (((DataView)this.dgAntiC3.DataSource).Table.Rows.Count == 0)
			{
				return true;
			}

			foreach(DataRow dr in this._dtDATC3d.Rows)
			{
				if (dr[TABLE.Reagent.LotNumber].ToString().Trim() != string.Empty)
					return false;
				if (dr[ARTIFICIAL.C3d].ToString().Trim() != string.Empty)
					return false;
				if (dr[ARTIFICIAL.CC].ToString().Trim() != string.Empty)
					return false;
				if (dr[ARTIFICIAL.C3dInterp].ToString().Trim() != string.Empty)
					return false;
				if (dr[ARTIFICIAL.C3dComment].ToString().Trim() != string.Empty)
					return false;
			}

			return true;
		}

		/// <summary>
		/// Check if there are any results from previous testing
		/// </summary>
		/// <returns></returns>
		private bool IsGridPartiallyCompleted()
		{
			foreach(DataRow dr in this._dtDATC3d.Rows)
			{
				if ((bool)dr[ARTIFICIAL.LotNumberSave] == false)
					return true;
				if ((bool)dr[ARTIFICIAL.C3dSave] == false)
					return true;
				if ((bool)dr[ARTIFICIAL.CCSave] == false)
					return true;
				if ((bool)dr[ARTIFICIAL.C3dInterpSave] == false)
					return true;
			}

			return false;
		}
		
		/// <summary>
		/// Copy the comment entered in the combo box to the cell
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBoxComment_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			try
			{
				int row = this.dgAntiC3.CurrentCell.RowNumber;
				int col = this.dgAntiC3.CurrentCell.ColumnNumber;

				if (col == 6)
				{
					this._dtDATC3d.Rows[row][ARTIFICIAL.C3dComment] = this.cmbBoxComment.Text;
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void _dcTextKeyTrapCol_MouseClick(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			try
			{
				if (e.Button == MouseButtons.Right)
				{
					if (this._dtDATC3d.Rows.Count > 0)
					{
						this.ContextMenu.Show(this, new Point(e.X, e.Y));
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgAntiC3_Enter(object sender, System.EventArgs e)
		{
			try
			{
				this.dgAntiC3.SetCurrentCell(0, 2);
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgAntiC3_Leave(object sender, System.EventArgs e)
		{
			try
			{
				for (int i=0 ; i<this._dtDATC3d.Rows.Count ; i++)
				{
					UpdateIndicator(i);
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgAntiC3_LostFocus(object sender, EventArgs e)
		{
			try
			{
				if (e.GetType().FullName == typeof(VbecsGridEventArgs).FullName)
				{
					if (((VbecsGridEventArgs)e).TabKeyPressed)
					{
						this.SelectNextControl(this.dgAntiC3,true,true,false,false);
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Checks if the reagent entered in the row has expired
		/// </summary>
		/// <param name="drLotNumber"></param>
		/// <returns></returns>
		private bool CheckForExpiredAntisera(System.Data.DataRow drLotNumber)
		{
			DateTime LotExpirationDate;
			DialogResult result = DialogResult.Yes;
			int row = this.dgAntiC3.CurrentCell.RowNumber;
			DateTime currentDate;

			currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			if(drLotNumber.IsNull(TABLE.Reagent.LotExpirationDate) == false)
			{
				LotExpirationDate = System.Convert.ToDateTime(drLotNumber[TABLE.Reagent.LotExpirationDate]);
			}
			else
			{
				LotExpirationDate = DateTime.MaxValue;
			}

			if(LotExpirationDate >= currentDate)
			{
				if ( ((System.TimeSpan)(LotExpirationDate - currentDate)).Days < 1)
				{
					string sDlgMessage = "Antisera will expire at ";
					sDlgMessage += Common.VBECSDateTime.FormatDateTimeString(LotExpirationDate);
					sDlgMessage += ". ";
					sDlgMessage += "Continue to use?";
					result = MessageBox.Show(sDlgMessage, Common.StrRes.ValidMsg.UC041.AntiseraExpire().ResString, MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation);
				
					if (result != DialogResult.Yes)
					{
						return false;
					}
				}
				this._dtDATC3d.Rows[row][ARTIFICIAL.ReagentExpiredException] = DBNull.Value;
			}
			else
			{

				DlgExpiredAntisera dlg = new DlgExpiredAntisera(string.Empty, (Guid)drLotNumber[TABLE.Reagent.ReagentGuid], drLotNumber[TABLE.ReagentType.ReagentTypeName].ToString(), drLotNumber[TABLE.Reagent.LotNumber].ToString(), (DateTime)drLotNumber[TABLE.Reagent.LotExpirationDate]);

                dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                dlg.ShowDialogFromLockedParent(parentForm, false);

				if (dlg.DialogResult != DialogResult.Yes)
				{

					DataRow drRemovedLotNumber = this._dtRemovedLotNumbers.NewRow();

					drRemovedLotNumber[ARTIFICIAL.Lot_Number] = drLotNumber[TABLE.Reagent.LotNumber];
					drRemovedLotNumber[ARTIFICIAL.Manufacturer] = drLotNumber[TABLE.Reagent.ReagentManufacturerName];
						
					this._dtRemovedLotNumbers.Rows.Add(drRemovedLotNumber);

					return false;
				}
				else
				{
					BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_reagent_QC, dlg.Comment, Common.LogonUser.LogonUserName);
					exRep.GenerateExceptionQC((Guid)drLotNumber[TABLE.Reagent.ReagentGuid], Guid.Empty, Guid.Empty, Guid.Empty, string.Empty, string.Empty, string.Empty, this.TestingTech);
					this._dtDATC3d.Rows[row][ARTIFICIAL.ReagentExpiredException] = exRep;
				}
			}

			return true;
		}

		/// <summary>
		/// Checks the inspection indicator on the reagent
		/// </summary>
		/// <param name="drLotNumber"></param>
		/// <returns></returns>
		private bool CheckForSatisfactoryReagent(DataRow drLotNumber)
		{
			string sDlgMessage;

			if ((bool)drLotNumber[TABLE.Reagent.InspectionIndicator] == false)
			{
				sDlgMessage = "Reagent (";
				sDlgMessage += drLotNumber[ARTIFICIAL.Manufacturer].ToString();
				sDlgMessage += " ";
				sDlgMessage += drLotNumber[ARTIFICIAL.Lot_Number].ToString();
				sDlgMessage += " ";
				sDlgMessage += drLotNumber[ARTIFICIAL.ExpirationDate].ToString();
				sDlgMessage += ") was recorded as Unsatisfactory during shipment receipt. You are not allowed to use this reagent.";

				MessageBox.Show(sDlgMessage, Common.StrRes.ValidMsg.UC041.AntigenTypingWeakD().ResString, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
				return false;
			}
			return true;
		}

		private void dgAntiC3_SizeChanged(object sender, EventArgs e)
		{
			try
			{
				if (this.dgAntiC3.TableStyles.Count>0)
				{
					DataGridTableStyle tblStyle = this.dgAntiC3.TableStyles[0];
					//
				    var dataGridColumnStyle = tblStyle.GridColumnStyles[ARTIFICIAL.C3dComment];
				    if (dataGridColumnStyle != null)
				    {
				        var gridColumnStyle = tblStyle.GridColumnStyles[ARTIFICIAL.Indicator];
				        if (gridColumnStyle != null)
				        {
				            var columnStyle = tblStyle.GridColumnStyles[ARTIFICIAL.TestType];
				            if (columnStyle != null)
				            {
				                var style = tblStyle.GridColumnStyles[TABLE.Reagent.LotNumber];
				                if (style != null)
				                {
				                    var dataGridColumnStyle1 = tblStyle.GridColumnStyles[ARTIFICIAL.C3d];
				                    if (dataGridColumnStyle1 != null)
				                    {
				                        var gridColumnStyle1 = tblStyle.GridColumnStyles[ARTIFICIAL.CC];
				                        if (gridColumnStyle1 != null)
				                        {
				                            var columnStyle1 = tblStyle.GridColumnStyles[ARTIFICIAL.C3dInterp];
				                            if (columnStyle1 != null)
				                                dataGridColumnStyle.Width = this.dgAntiC3.Width -
				                                                            (gridColumnStyle.Width +
				                                                             columnStyle.Width +
				                                                             style.Width +
				                                                             dataGridColumnStyle1.Width +
				                                                             gridColumnStyle1.Width +
				                                                             columnStyle1.Width + 7);
				                        }
				                    }
				                }
				            }
				        }
				    }
				    var style1 = tblStyle.GridColumnStyles[ARTIFICIAL.C3dComment];
				    if (style1 != null)
				        this.cmbBoxComment.Width = style1.Width;
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}
	}
}
